% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_data.R
\name{promptness_ecdf}
\alias{promptness_ecdf}
\title{Compute the empirical cumulative distribution function for promptness}
\usage{
promptness_ecdf(promptness, adjust_for_times = TRUE, eval_unique = FALSE)
}
\arguments{
\item{promptness}{A vector of promptness values (1 / times)}

\item{adjust_for_times}{If \code{TRUE} (the default), the returned \code{y} value is
such that \verb{1 - y = P(1/promptness <= 1/x). If }FALSE\verb{, the returned }y\verb{value is such that}y = P(promptness <= x)`.}

\item{eval_unique}{If \code{FALSE} (the default), the ECDF is evaluated at all
values in \code{promptness}. If \code{TRUE}, the ECDF is evaluated at the unique
values in \code{promptness}.}
}
\value{
A data frame with attributes:
\itemize{
\item \code{x} is the values at which the ECDF was evaluated.
\item \code{y} is the evaluated value of the ECDF.
}
}
\description{
Compute the empirical cumulative distribution function for promptness
}
\examples{
p <- promptness_ecdf(promptness = rnorm(100, 3, 1))
}
