% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_functions.R
\name{hdchange}
\alias{hdchange}
\title{Estimate the time-stamps and spatial locations with breaks}
\usage{
hdchange(hdobj)
}
\arguments{
\item{hdobj}{An S3 object of class 'no_nbd' or 'nbd' generated
by \code{\link[=ts_hdchange]{ts_hdchange()}}.}
}
\value{
The return value is an S3 object of class 'no_nbd' or 'nbd' containing a list
of the test results and change-point locations.
}
\description{
The main function of this package. It performs a test for existence of
breaks and estimates the time-stamps and locations of the breaks.
}
\examples{
############ No neighbourhood case ############

# generate data
data_no_nbd <- sim_hdchange_no_nbd(n = 200,
p = 30,
S = 30,
tau = c(40, 100, 160),
dist_info =
  list(dist = "normal", dependence = "MA_inf", param = 1),
jump_max = c(2, 2, 1.5))

# construct no_nbd object
ts_no_nbd <- ts_hdchange(data_no_nbd,
window_size = 30,
m = 8,
h = 1,
N_rep = 999,
alpha = 1e-5,
quantiles = c(0.01, 0.05, 0.1))

\donttest{

# Estimate the time-stamps of the breaks
est_result_no_nbd <- hdchange(ts_no_nbd)

# Summarize the results
summary(est_result_no_nbd)

# Plot the results
plot_result(est_result_no_nbd)
axis(1,
  at = est_result_no_nbd$time_stamps,
  labels = c("break 1", "break 2", "break 3")
)
title(main = "Change-points estimation")
}

############ Neighbourhood case ############

# generate data
data_nbd <- sim_hdchange_nbd(n = 300,
p = 70,
nbd_info =
 list(
   (1:9), (2:31), (32:41), (42:70),
   (3:15), (16:35), (31:55)
 ),
sp_tp_break = rbind(c(2, 50), c(4, 150), c(2, 250)),
dist_info =
  list(dist = "t", dependence = "iid", param = 5),
jump_max = 1)

# construct nbd object
ts_nbd <- ts_hdchange(data_nbd,
window_size = 30,
m = 8,
h = 1,
N_rep = 999,
alpha = 1e-5,
quantiles = c(0.01, 0.05, 0.1),
nbd_info =
 list(
   (1:9), (2:31), (32:41), (42:70),
   (3:15), (16:35), (31:55)
 ))

\donttest{

# Estimate the time-stamps of the breaks
est_result_nbd <- hdchange(ts_nbd)

# Summarize the results
summary(est_result_nbd)

# Plot the results
plot_result(est_result_nbd, nbd_index = 2)
pairs <- est_result_nbd$nbd_and_stamps_pair
time_stamps <- pairs[pairs[, 1] == 2, 2]
axis(1,
  at = time_stamps,
  labels = c("break 1", "break 2")
)
title(main = "Change-points estimation for neibourhood 2")
}
}
\references{
Li, J., Chen, L., Wang, W. and Wu, W.B., 2022. \eqn{\ell^2} Inference for Change Points in High-Dimensional Time Series via a Two-Way MOSUM.
\emph{arXiv preprint arXiv:2208.13074}.
}
