% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ksic.R
\name{ksic}
\alias{ksic}
\title{Get KSIC Data}
\usage{
ksic(digit = 5, C = NULL, eng_nm = FALSE)
}
\arguments{
\item{digit}{integer. The digit of the classification to extract (1-5). Default is 5.}

\item{C}{integer. The KSIC revision (9, 10, or 11). If NULL, \code{getOption("ksic.C", 11)} is used.}

\item{eng_nm}{logical. If \code{TRUE}, includes English classification names; if \code{FALSE}, excludes them. Default is \code{FALSE}.}
}
\value{
A data.frame containing the specified KSIC codes and names.
}
\description{
Returns a data.frame of KSIC data for the specified revision and digit.
}
\examples{
ksic(digit = 1)

ksic(digit = 2, C = 10, eng_nm = TRUE)
}
