% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_kols.R
\name{plot_kols}
\alias{plot_kols}
\title{Plot a KOL team in a network}
\usage{
plot_kols(
  KOL,
  team = 1,
  kol = "red",
  reachable = "green",
  attribute = TRUE,
  ...
)
}
\arguments{
\item{KOL}{a KOL object generated by \code{pick_kols()}}

\item{team}{numeric: number of team in \code{KOL} to plot}

\item{kol}{color to mark KOLs}

\item{reachable}{color to mark nodes reachable by KOLs}

\item{attribute}{boolean: if a node attribute was used to measure KOL team diversity, should nodes be colored accordingly}

\item{...}{arguments passed to \code{igraph} plot function}
}
\value{
an igraph plot
}
\description{
Plot a KOL team in a network
}
\examples{
network <- igraph::sample_smallworld(1,26,2,.2)  #An example network
teams <- pick_kols(network, m = 2)  #Find KOL teams
plot_kols(teams,
          vertex.label = NA,
          vertex.frame.width = 3)
}
