
#' Divisor combination generator
#'
#' @description Generating all possible divisor combination of certain length for a given positive integer.
#' @param x A positive integer.
#' @param d A vector of positive integers whose length is the length of divisor combination and each value sets the maximum of each divisor.
#'
#' @return A matrix with each row representing a divisor combination.
#'
#' @export
#'
#' @examples
#' divisors(6, c(20,20));
#'
#'
divisors <- function(x, d){
  if (length(d)==1){return(d)}
  if (x<1){
    message("Parameter `x` should be positive.")
    return()
  }
  if (sum(d<=0)!=0){
    message("Parameter `d` should be a vector of all positive values.")
    return()
  }

  vec_x <- matrix(1:x, ncol=1)
  res_x <- 1
  for (i in 1:length(d)){ res_x <- res_x %x% vec_x }
  div_vec <- which(res_x == x)

  div_mat <- matrix(nrow=length(div_vec), ncol=length(d))
  for (i in seq_along(div_vec)){
    for (j in length(d):1){
      div_mat[i,j] <- (div_vec[i] %% x) + x*as.numeric((div_vec[i] %% x)==0)
      div_vec[i] <- (div_vec[i] %/% x) + 1 - as.numeric((div_vec[i] %% x)==0)
    }
  }

  remove_vec <- numeric() ## check number of factors larger than dimensions
  for (i in seq_len(nrow(div_mat))){ if (sum(div_mat[i,] > d) !=0 ){ remove_vec <- c(remove_vec, i) } }

  if (length(remove_vec) == 0){
    return(div_mat)
  } else {
    return( div_mat[-remove_vec,] )
  }
}
