% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Kernel_lasso.R
\name{kernel_lasso_expansion}
\alias{kernel_lasso_expansion}
\title{kernel_lasso_expansion}
\source{
https://github.com/Zongrui-Dai/Kernel-lasso-feature-expansion
}
\arguments{
\item{x}{Your input features, which have to be data.frame with at least two variables.}

\item{y}{The dependent variable}

\item{sigma}{The hyperparameter of RBF kernel function, which indicates the width.}

\item{dataframe}{Wether the data is dataframe. The default is TURE}

\item{standard}{Using 'max_min_scale' or 'Z_score' method to standardize the data. NULL means no standardization}
}
\value{
The result is stored in one list which contains the orignial dataset, amplified dataset, final features, and lasso output.
}
\description{
Kernel_lasso is one feature selection method, which combines the feature expansion and lasso regression together. Kernel function will increase the dimensions of the existed data and then reduce the features by lasso. 'glmnet' package should be higher than 4.1-2.
}
\examples{
##Regression (MSE)
data(attenu,package = 'datasets')
result<-kernel_lasso_expansion(x=attenu[,-c(3,5)],y=attenu[,5],
standard = 'max_min',sigma=0.01,control = lasso.control(nfolds=3,type.measure = 'mse'))
summary(result)

#Plot the lasso
plot(result$lasso)

#Result
result$original ##The original feature space
result$expansion  ##The feature space after expansion
result$final_feature  ##The name of the final feature
result$final_data  ##The dataframe of final feature

}
\references{
Z. Dai, J. Li, T. Gong, C. Wang (2021), Kernel_lasso feature expansion method: boosting the prediction ability of machine learning in heart attack,” 2021 IEEE.  About  Kernel-lasso feature expansion method: boosting the prediction ability of machine learning in heart attack” 2021 IEEE.
}
\author{
Zongrui Dai
}
\keyword{kernel_lasso_expansion}
