% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.KFPCA.R
\name{predict.KFPCA}
\alias{predict.KFPCA}
\title{Predict FPC scores}
\usage{
\method{predict}{KFPCA}(object, newLt, newLy, nK, more = FALSE, ...)
}
\arguments{
\item{object}{A KFPCA object obtained from \code{\link[KFPCA]{KFPCA}}.}

\item{newLt}{A \code{list} of \emph{n} vectors, where \emph{n} is the new sample size. Each entry contains the observation time in ascending order for each new subject.}

\item{newLy}{A \code{list} of \emph{n} vectors, where \emph{n} is the new sample size. Each entry contains the measurements of each new subject at the observation time correspond to \code{newLt}.}

\item{nK}{An integer denoting the number of FPCs.}

\item{more}{Logical; If \code{FALSE}, only the predictions of FPC scores are returned. If \code{TRUE}, the mean function estimates and the eigenfunction estimates at the new observation time points are also returned.}

\item{...}{Not used.}
}
\value{
If \code{more = FALSE}, a \emph{n} by \code{nK} \code{matrix} containing the predictions of the FPC scores is returned, where \emph{n} is the new sample size. If \code{more = TRUE}, a \code{list} containing the following components is returned:
\item{score_new}{a \emph{n} by \code{nK} \code{matrix} containing the predictions of the FPC scores.}
\item{meanest_new}{Mean function estimates at the new observation time points.}
\item{FPC_dis_new}{Eigenfunction estimates at the new observation time points.}
}
\description{
Predict FPC scores using least square estimate (LSE) for a new sample.
}
\examples{
# Generate training data
n <- 100
interval <- c(0, 10)
lambda_1 <- 9 #the first eigenvalue
lambda_2 <- 1.5 #the second eigenvalue
eigfun <- list()
eigfun[[1]] <- function(x){cos(pi * x/10)/sqrt(5)}
eigfun[[2]] <- function(x){sin(pi * x/10)/sqrt(5)}
score <- cbind(rnorm(n, 0, sqrt(lambda_1)), rnorm(n, 0, sqrt(lambda_2)))
DataNew <- GenDataKL(n, interval = interval, sparse = 6:8, regular = FALSE,
                     meanfun = function(x){0}, score = score,
                     eigfun = eigfun, sd = sqrt(0.1))
basis <- fda::create.bspline.basis(interval, nbasis = 13, norder = 4,
                              breaks = seq(0, 10, length.out = 11))
Klist <- KFPCA(DataNew$Lt, DataNew$Ly, interval, nK = 2, bw = 1,
               nRegGrid = 51, fdParobj = basis)
# Generate test data
n_test <- 20
score_test <- cbind(rnorm(n_test, 0, sqrt(lambda_1)),
                    rnorm(n_test, 0, sqrt(lambda_2)))
Data_test <- GenDataKL(n_test, interval = interval, sparse = 6:8, regular = FALSE,
                       meanfun = function(x){0}, score = score_test,
                       eigfun = eigfun, sd = sqrt(0.1))
# Prediction
score_pre <- predict(Klist, Data_test$Lt, Data_test$Ly, nK = 2)
plot(score_test[,1], score_pre[,1])
}
