% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpfunctions_ranefs.R
\name{hc_rdslope_info}
\alias{hc_rdslope_info}
\title{Get info on the main effects in a random slope structure
for a given level and sub-model}
\usage{
hc_rdslope_info(hc_cols, parelmts)
}
\arguments{
\item{hc_cols}{list of lists (one per random effect), each containing a list
with elements "main" and "interact" that contain information
on the column number and name of the design matrix for the
random effects variables or variables interacting with them}

\item{parelmts}{list (per design matrix) of indices of the regression
coefficients used for that sub-model (named with the
corresponding column name of the design matrix)}
}
\value{
a \code{data.frame} with columns
\itemize{
\item \code{rd_effect}: name of the main random effect,
\item \code{term}: the name of the random effect,
\item \code{matrix}: the name of the design matrix,
\item \code{cols}: the column index of the design matrix,
\item \code{parelmts} (the index of the corresponding regression coefficient
and one row per (main) random effect
}
}
\description{
Get info on the main effects in a random slope structure
for a given level and sub-model
}
\details{
Argument \code{hc_cols} should have the structure:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{list(
  "(Intercept)" = list(main = c(M_id = 1),
                       interact = NULL),
  time = list(main = c(M_lvlone = 4),
              interact = list("C1:time" = list(interterm = c(M_lvlone = 6),
                                               elmts = c(M_id = 2,
                                                         M_lvlone = 4)),
                              "b21:time" = list(interterm = c(M_lvlone = 7),
                                                elmts = c(M_lvlone = 3,
                                                          M_lvlone = 4))
              )
  ),
  "I(time^2)" = list(main = c(M_lvlone = 5),
                     interact = NULL)
)
}\if{html}{\out{</div>}}

Argument \code{parelmts} is a list of lists instead of a list of vectors in
case of a multinomial model or cumulative logit model with non-proportional
effects.
}
\keyword{internal}
