% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psSignal.R
\name{psSignal}
\alias{psSignal}
\title{Smooth signal (multivariate calibration) regression using P-splines.}
\usage{
psSignal(
  y,
  x_signal,
  x_index = c(1:ncol(x_signal)),
  nseg = 10,
  bdeg = 3,
  pord = 3,
  lambda = 1,
  wts = 1 + 0 * y,
  family = "gaussian",
  link = "default",
  m_binomial = 1 + 0 * y,
  r_gamma = wts,
  y_predicted = NULL,
  x_predicted = x_signal,
  ridge_adj = 0,
  int = TRUE
)
}
\arguments{
\item{y}{a (glm) response vector, usually continuous, binomial or count data.}

\item{x_signal}{a matrix of continuous regressor with \code{nrow(x_signal) == length(y)}, often
a discrete digitization of a signal or histogram or time series.}

\item{x_index}{a vector to of length \code{ncol(x_signal) == p}, associated with the
ordering index of the signal. Default is \code{1:ncol(x_signal)}.}

\item{nseg}{the number of evenly spaced segments between \code{xl} and \code{xr} (default 10).}

\item{bdeg}{the degree of the basis, usually 1, 2, or 3 (defalult).}

\item{pord}{the order of the difference penalty, usually 1, 2, or 3 (defalult).}

\item{lambda}{the (positive) tuning parameter for the penalty (default 1).}

\item{wts}{the weight vector of \code{length(y)}; default is 1.}

\item{family}{the response distribution, e.g.
\code{"gaussian", "binomial", "poisson", "Gamma"} distribution; quotes are needed. Default is \code{"gaussian"}.}

\item{link}{the link function, one of \code{"identity"}, \code{"log"}, \code{"sqrt"},
\code{"logit"}, \code{"probit"}, \code{"cloglog"}, \code{"loglog"}, \code{"reciprocal"};
quotes are needed (default \code{"identity"}).}

\item{m_binomial}{a vector of binomial trials having length(y); default is 1 vector for \code{family = "binomial"}, NULL otherwise.}

\item{r_gamma}{a vector of gamma shape parameters. Default is 1 vector for \code{family = "Gamma"}, NULL otherwise.}

\item{y_predicted}{a vector of responses associated
with \code{x_predicted} which are used to calculate standard error of external prediction. Default is NULL.}

\item{x_predicted}{a matrix of external signals to yield external prediction.}

\item{ridge_adj}{A ridge penalty tuning parameter, which can be set to small value, e.g. \code{1e-8} to stabilize estimation, (default 0).}

\item{int}{set to TRUE or FALSE to include intercept term in linear predictor (default TRUE).}
}
\value{
\item{coef}{a vector with \code{length(n)} of estimated P-spline coefficients.}
\item{mu}{a vector with \code{length(m)} of estimated means.}
\item{eta}{a vector of \code{length(m)} of estimated linear predictors.}
\item{B}{the B-spline basis (for the coefficients), with dimension \code{p} by \code{n}.}
\item{deviance}{the deviance of fit.}
\item{eff_df}{the approximate effective dimension of fit.}
\item{aic}{AIC.}
\item{df_resid}{approximate df residual.}
\item{beta}{a vector of length \code{p}, containing estimated smooth signal coefficients.}
\item{std_beta}{a vector of length \code{p}, containing standard errors of smooth signal coefficients.}
\item{cv}{leave-one-out standard error prediction, when \code{family = "gaussian"}.}
\item{cv_predicted}{standard error prediction for \code{y_predict}, when \code{family = "gaussian"}, NULL otherwise.}
\item{nseg}{the number of evenly spaced B-spline segments.}
\item{bdeg}{the degree of B-splines.}
\item{pord}{the order of the difference penalty.}
\item{lambda}{the positive tuning parameter.}
\item{family}{the family of the response.}
\item{link}{the link function.}
\item{y_intercept}{the estimated y-intercept (when \code{int = TRUE}.)}
\item{int}{a logical variable related to use of y-intercept in model.}
\item{dispersion_param}{estimate of dispersion, \code{Dev/df_resid}.}
\item{summary_predicted}{inverse link prediction vectors, and twice se bands.}
\item{eta_predicted}{estimated linear predictor of \code{length(y)}.}
\item{press_mu}{leave-one-out prediction of mean, when \code{family = "gaussian"}, NULL otherwise.}
\item{bin_percent_correct}{percent correct classification based on 0.5 cut-off, when \code{family = binomial}, NULL otherwise.}
\item{x_index}{a vector to of length \code{ncol(x_signal) == p}, associated with the ordering of the signal.}
}
\description{
Smooth signal (multivariate calibration) regression using P-splines.
}
\details{
Support functions needed: \code{pspline_fitter}, \code{bbase} and \code{pspline_checker}.
}
\examples{
library(JOPS)
# Get the data
library(fds)
data(nirc)
iindex <- nirc$x
X <- nirc$y
sel <- 50:650 # 1200 <= x & x<= 2400
X <- X[sel, ]
iindex <- iindex[sel]
dX <- diff(X)
diindex <- iindex[-1]
y <- as.vector(labc[1, 1:40]) # percent fat
oout <- 23
dX <- t(dX[, -oout])
y <- y[-oout]
fit1 <- psSignal(y, dX, diindex, nseg = 25, bdeg = 3, lambda = 0.0001,
pord = 2, family = "gaussian", link = "identity", x_predicted = dX, int = TRUE)
plot(fit1, xlab = "Coefficient Index", ylab = "ps Smooth Coeff")
title(main = "25 B-spline segments with tuning = 0.0001")
names(fit1)
}
\references{
Marx, B.D. and Eilers, P.H.C. (1999). Generalized linear regression for sampled signals and
curves: A P-spline approach. \emph{Technometrics}, 41(1): 1-13.

Eilers, P.H.C. and Marx, B.D. (2021). \emph{Practical Smoothing, The Joys of
P-splines.} Cambridge University Press.
}
\author{
Brian Marx
}
