% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_support.R
\name{predict.pssignal}
\alias{predict.pssignal}
\title{Predict function for \code{psSignal}}
\usage{
\method{predict}{pssignal}(object, ..., X_pred, type = "mu")
}
\arguments{
\item{object}{an object using \code{psSignal}.}

\item{...}{other parameters.}

\item{X_pred}{a matrix of arbitrary signals with \code{ncol(X) == length(x_index)} locations for
desired prediction.}

\item{type}{the mean value \code{type = "mu"} (default) or linear predictor
\code{type = "eta"}.}
}
\value{
\item{pred}{the estimated mean (inverse link function) (default)
or the linear predictor prediction with \code{type =
"eta"}, for a matrix of signals in \code{X_pred}.}
}
\description{
Prediction function which returns both linear
predictor and inverse link predictions, for an arbitrary matrix of signals
(using \code{psSignal} with \code{class pssignal}).
}
\examples{
library(JOPS)
# Get the data
library(fds)
data(nirc)
iindex=nirc$x
X=nirc$y
sel= 50:650 #1200 <= x & x<= 2400
X=X[sel,]
iindex=iindex[sel]
dX=diff(X)
diindex=iindex[-1]
y=as.vector(labc[1,1:40])
oout=23
dX=t(dX[,-oout])
y=y[-oout]
fit1 = psSignal(y, dX, diindex, nseg = 25,lambda = 0.0001)
predict(fit1, X_pred = dX[1:5, ])
predict(fit1, X_pred = dX[1:5, ], type = 'eta')
}
\references{
Marx, B.D. and Eilers, P.H.C. (1999). Generalized linear regression for sampled signals and
       curves: A P-spline approach. \emph{Technometrics}, 41(1): 1-13.

Eilers, P.H.C. and Marx, B.D. (2021). \emph{Practical Smoothing, The Joys of
P-splines.} Cambridge University Press.
}
\author{
Paul Eilers and Brian Marx
}
