% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alignments.R
\name{track_alignments}
\alias{track_alignments}
\title{Create an AlignmentsTrack for a custom JBrowse 2 view}
\usage{
track_alignments(track_data, assembly)
}
\arguments{
\item{track_data}{the URL to the BAM/CRAM alignments}

\item{assembly}{the config string generated by \code{assembly}}
}
\value{
a character vector of stringified AlignmentsTrack JSON configuration
}
\description{
Creates the necessary configuration string for an
indexed BAM or CRAM alignment so that it can be used
in a JBrowse custom linear genome view.
}
\details{
It is important to note that while only the BAM/CRAM file is
passed as an argument, \code{tracks_alignment} assumes that a BAM/CRAM
index of the same name is located with the file

For example:

\code{track_alignments("data/alignments.bam")}

Assumes that \code{data/alignments.bam.bai} also exists.

This is a JBrowse 2 convention, and the default naming output of samtools

For more information on creating an index with samtools, visit
\url{https://www.htslib.org/}
}
\examples{
assembly <- assembly("https://jbrowse.org/genomes/hg19/fasta/hg19.fa.gz", bgzip = TRUE)

track_alignments("alignments.bam", assembly)
track_alignments("alignments.cram", assembly)
}
