% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/york.R
\name{data2york}
\alias{data2york}
\alias{data2york.default}
\alias{data2york.other}
\alias{data2york.UPb}
\alias{data2york.ArAr}
\alias{data2york.ThPb}
\alias{data2york.KCa}
\alias{data2york.PbPb}
\alias{data2york.PD}
\alias{data2york.UThHe}
\alias{data2york.ThU}
\title{Prepare geochronological data for York regression}
\usage{
data2york(x, ...)

\method{data2york}{default}(x, format = 1, ...)

\method{data2york}{other}(x, ...)

\method{data2york}{UPb}(x, option = 1, tt = 0, ...)

\method{data2york}{ArAr}(x, inverse = TRUE, ...)

\method{data2york}{ThPb}(x, inverse = FALSE, ...)

\method{data2york}{KCa}(x, inverse = FALSE, ...)

\method{data2york}{PbPb}(x, inverse = TRUE, ...)

\method{data2york}{PD}(x, exterr = FALSE, inverse = FALSE, ...)

\method{data2york}{UThHe}(x, ...)

\method{data2york}{ThU}(x, type = 2, generic = TRUE, ...)
}
\arguments{
\item{x}{a five or six column matrix OR an object of class
\code{UPb}, \code{PbPb}, \code{ThPb}, \code{ArAr}, \code{ThU},
\code{UThHe}, or \code{PD} (which includes objects of class
\code{RbSr}, \code{SmNd}, \code{LuHf} and \code{ReOs}),
generated by the \code{read.data(...)} function}

\item{...}{optional arguments}

\item{format}{one of

\code{1} or \code{2}: \code{X}, \code{s[X]}, \code{Y}, \code{s[Y]},
\code{rXY}; where \code{rXY} is the error correlation between
\code{X} and \code{Y}; or

\code{3}: \code{X/Z}, \code{s[X/Z]}, \code{Y/Z}, \code{s[Y/Z]},
\code{X/Y}, \code{s[X/Y]}; for which the error correlations are
automatically computed from the redundancy of the three ratios.}

\item{option}{one of

\code{1}: Wetherill concordia ratios: \code{X=07/35},
\code{sX=s[07/35]}, \code{Y=06/38}, \code{sY=s[06/38]}, \code{rXY}.

\code{2}: Tera-Wasserburg ratios: \code{X=38/06},
\code{sX=s[38/06]}, \code{Y=07/06}, \code{sY=s[07/06]}, \code{rXY}.

\code{3}: \code{X=38/06}, \code{sX=s[38/06]}, \code{Y=04/06},
\code{sY=s[04/06]}, \code{rXY} (only valid if \code{x$format=4,5}
or \code{6}).

\code{4}: \code{X=35/07}, \code{sX=s[35/07]}, \code{Y=04/07},
\code{sY=s[04/07]}, \code{rXY} (only valid if \code{x$format=4,5}
or \code{6}).

\code{5}: U-Th-Pb concordia ratios: \code{X=06/38},
\code{sX=s[06/38]}, \code{Y=08/32}, \code{sY=s[08/32]},
\code{rXY} (only valid if \code{x$format=7,8}).

\code{6}: \code{X=38/06}, \code{sX=s[38/06]}, \code{Y=08/06},
\code{sY=s[08/06]}, \code{rXY} (only valid if \code{x$format=7,8}).

\code{7}: \code{X=35/07}, \code{sX=s[35/07]}, \code{Y=08/07},
\code{sY=s[08/07]}, \code{rXY} (only valid if \code{x$format=7,8}).

\code{8}: \code{X=32/08}, \code{sX=s[32/08]}, \code{Y=06/08},
\code{sY=s[06/08]}, \code{rXY} (only valid if \code{x$format=7,8}).

\code{9}: \code{X=32/08}, \code{sX=s[32/08]}, \code{Y=07/08},
\code{sY=s[07/08]}, \code{rXY} (only valid if \code{x$format=7,8}).}

\item{tt}{the age of the sample. This is only used if
\code{x$format=7} or \code{8}, in order to calculate the
inherited \eqn{{}^{208}}Pb/\eqn{{}^{232}}Th ratio.}

\item{inverse}{toggles between normal and inverse isochron
    ratios. \code{data2york} returns five columns \code{X},
    \code{s[X]}, \code{Y}, \code{s[Y]} and \code{r[X,Y]}.

If \code{inverse=TRUE}, then \code{X} =
\eqn{{}^{204}}Pb/\eqn{{}^{206}}Pb and \code{Y} =
\eqn{{}^{207}}Pb/\eqn{{}^{206}}Pb (if \code{x} has class
\code{PbPb}), or \code{X} = \eqn{{}^{232}}Th/\eqn{{}^{208}}Pb and
\code{Y} = \eqn{{}^{204}}Pb/\eqn{{}^{208}}Pb (if \code{x} has class
\code{ThPb}), or \code{X} = \eqn{{}^{39}}Ar/\eqn{{}^{40}}Ar and
\code{Y} = \eqn{{}^{36}}Ar/\eqn{{}^{40}}Ar (if \code{x} has class
\code{ArAr}), or \code{X} = \eqn{{}^{40}}K/\eqn{{}^{40}}Ca and
\code{Y} = \eqn{{}^{44}}Ca/\eqn{{}^{40}}Ca (if \code{x} has class
\code{KCa}), or \code{X} = \eqn{{}^{87}}Rb/\eqn{{}^{87}}Sr and
\code{Y} = \eqn{{}^{86}}Sr/\eqn{{}^{87}}Sr (if \code{x} has class
\code{RbSr}), or \code{X} = \eqn{{}^{147}}Sm/\eqn{{}^{143}}Nd and
\code{Y} = \eqn{{}^{144}}Nd/\eqn{{}^{143}}Nd (if \code{x} has class
\code{SmNd}), or \code{X} = \eqn{{}^{187}}Re/\eqn{{}^{187}}Os and
\code{Y} = \eqn{{}^{188}}Os/\eqn{{}^{187}}Os (if \code{x} has class
\code{ReOs}), or \code{X} = \eqn{{}^{176}}Lu/\eqn{{}^{176}}Hf and
\code{Y} = \eqn{{}^{177}}Hf/\eqn{{}^{176}}Hf (if \code{x} has class
\code{LuHf}).

If \code{inverse=FALSE}, then \code{X} =
\eqn{{}^{206}}Pb/\eqn{{}^{204}}Pb and \code{Y} =
\eqn{{}^{207}}Pb/\eqn{{}^{204}}Pb (if \code{x} has class
\code{PbPb}), or \code{X} = \eqn{{}^{232}}Th/\eqn{{}^{204}}Pb and
\code{Y} = \eqn{{}^{208}}Pb/\eqn{{}^{204}}Pb (if \code{x} has class
\code{ThPb}), or \code{X} = \eqn{{}^{39}}Ar/\eqn{{}^{36}}Ar and
\code{Y} = \eqn{{}^{40}}Ar/\eqn{{}^{36}}Ar (if \code{x} has class
\code{ArAr}), or \code{X} = \eqn{{}^{40}}K/\eqn{{}^{44}}Ca and
\code{Y} = \eqn{{}^{40}}Ca/\eqn{{}^{44}}Ca (if \code{x} has class
\code{KCa}), or \code{X} = \eqn{{}^{87}}Rb/\eqn{{}^{86}}Sr and
\code{Y} = \eqn{{}^{87}}Sr/\eqn{{}^{86}}Sr (if \code{x} has class
\code{RbSr}), or \code{X} = \eqn{{}^{147}}Sm/\eqn{{}^{144}}Nd and
\code{Y} = \eqn{{}^{143}}Nd/\eqn{{}^{144}}Nd (if \code{x} has class
\code{SmNd}), or \code{X} = \eqn{{}^{187}}Re/\eqn{{}^{188}}Os and
\code{Y} = \eqn{{}^{187}}Os/\eqn{{}^{188}}Os (if \code{x} has class
\code{ReOs}), or \code{X} = \eqn{{}^{176}}Lu/\eqn{{}^{177}}Hf and
\code{Y} = \eqn{{}^{176}}Hf/\eqn{{}^{177}}Hf (if \code{x} has class
\code{LuHf}).}

\item{exterr}{If \code{TRUE}, propagates the external uncertainties
(e.g. decay constants) into the output errors.}

\item{type}{Return `Rosholt' or `Osmond' ratios?

Rosholt (\code{type=1}) returns \code{X=8/2}, \code{sX=s[8/2]},
\code{Y=0/2}, \code{sY=s[0/2]}, \code{rXY}.

Osmond (\code{type=2}) returns \code{X=2/8}, \code{sX=s[2/8]},
\code{Y=0/8}, \code{sY=s[0/8]}, \code{rXY}.}

\item{generic}{If \code{TRUE}, uses the following column headers:
    \code{X}, \code{sX}, \code{Y}, \code{sY}, \code{rXY}.

If \code{FALSE} and \code{type=1}, uses \code{U238Th232},
\code{errU238Th232}, \code{Th230Th232}, \code{errTh230Th232}, \code{rXY}

or if \code{FALSE} and \code{type=2}, uses \code{Th232U238},
\code{errTh232U238}, \code{Th230U238}, \code{errTh230U238}, \code{rXY}.}
}
\value{
a five-column table that can be used as input for
    \code{\link{york}}-regression.
}
\description{
Takes geochronology data as input and produces a five-column table
with the variables, their uncertainties and error correlations as
output. These can subsequently be used for York regression.
}
\examples{
f <- system.file("RbSr1.csv",package="IsoplotR")
dat <- read.csv(f)
yorkdat <- data2york(dat)
fit <- york(yorkdat)

}
\seealso{
\code{\link{york}}
}
