% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{simulate_Isingland}
\alias{simulate_Isingland}
\alias{simulate_Isingland.2d_Isingland}
\alias{simulate_Isingland.2d_Isingland_matrix}
\title{Simulate a 2D Ising landscape}
\usage{
simulate_Isingland(l, ...)

\method{simulate_Isingland}{`2d_Isingland`}(
  l,
  mode = "single",
  initial = 0,
  length = 100,
  beta2 = l$beta,
  ...
)

\method{simulate_Isingland}{`2d_Isingland_matrix`}(
  l,
  mode = "single",
  initial = 0,
  length = 100,
  beta2 = NULL,
  ...
)
}
\arguments{
\item{l}{An \code{Isingland} object constructed with \code{\link[=make_2d_Isingland]{make_2d_Isingland()}} or \code{\link[=make_2d_Isingland_matrix]{make_2d_Isingland_matrix()}}.}

\item{...}{Not in use.}

\item{mode}{One of \code{"single"}, \code{"distribution"}. Do you want to simulate
the state of a single system stochastically or simulate the distribution
of the states? \code{"single"} is used by default.}

\item{initial}{An integer indicating the initial number
of active nodes for the simulation. Float numbers will be
converted to an integer automatically.}

\item{length}{An integer indicating the simulation length.}

\item{beta2}{The \eqn{beta} value used for simulation. By default use
the same value as for landscape construction. Manually setting this
value can make the system easier or more difficult to transition
to another state, but will alter the steady-state distribution as well.}
}
\value{
A \code{sim_Isingland} object with the following components:
\itemize{
\item \code{output} A tibble of the simulation output.
\item \code{landscape} The landscape object supplied to this function.
\item \code{mode} A character representing the mode of the simulation.
}
}
\description{
Perform a numeric simulation using the landscape. The simulation is performed
using a similar algorithm as Glauber dynamics, that the transition possibility
is determined by the difference in the potential function, and the steady-state
distribution is the same as the Boltzmann distribution (if not setting \code{beta2}).
Note that, the conditional transition possibility of this simulation
may be different from Glauber dynamics or other simulation methods.
}
\details{
In each simulation step, the system can have one more active node, one
less active node, or the same number of active nodes (if possible; so if all
nodes are already active then it is not possible to have one more active node).
The possibility of the three cases is determined by their potential function:

\deqn{P(n_{t}=b|n_{t-1}=a) = \frac{e^{-\beta U(b)}}{\sum_{i \in \{a-1,a,a+1\},0\leq i\leq N}e^{-\beta U(i)}}, \ \mathrm{if} \ b\in\{a-1,a,a+1\}\ \&\ 0\leq i\leq N; 0, \mathrm{otherwise},}

where \eqn{n_{t}} is the number of active nodes at the time \eqn{t}, and
\eqn{U(n)} is the potential function.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
Nvar <- 10
m <- rep(0, Nvar)
w <- matrix(0.1, Nvar, Nvar)
diag(w) <- 0
result1 <- make_2d_Isingland(m, w)
plot(result1)

set.seed(1614)
sim1 <- simulate_Isingland(result1, initial = 5)
plot(sim1)
\dontshow{\}) # examplesIf}
}
