% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rectifiedI.R
\name{summaryLocalIVector}
\alias{summaryLocalIVector}
\title{Calculates statistic for the received Matrix.}
\usage{
summaryLocalIVector(vec)
}
\arguments{
\item{vec}{the vector to calculate the summary.}
}
\value{
a list with mean, standard deviation, maximum, minimum, 0.1\% and 99.9\% quantile and median of the received vector.
}
\description{
\code{summaryLocalIVector}. Calculates basic statistic of the received Matrix, like mean, standard deviation, maximum, minimum, 0.1\% and 99.9\% quantile and median.
}
\examples{
inputFileName<-system.file("testdata", "chen.csv", package="Irescale")
input<-loadFile(inputFileName)
distM<-calculateEuclideanDistance(input$data)
vI<-resamplingLocalI(input$varOfInterest,distM)
statsVI<-summaryLocalIVector(vI)
}
