% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rectifiedI.R
\name{calculateMoranI}
\alias{calculateMoranI}
\title{Calculates the Moran's I using the algorithm proposed by Chen \insertCite{chen2009}{Irescale}.}
\usage{
calculateMoranI(distM, varOfInterest, scaling = TRUE)
}
\arguments{
\item{distM}{the distance matrix. Altough the equation asks for weighted distant matrix, the paramenter that is required is only the distance matrix because this procedure calculate calculates the weighted distance mantrix by itself.}

\item{varOfInterest}{the variable of interest to calculate Moran's I.}

\item{scaling}{if the values are previously scaled, set this parameter to False. The default value is TRUE.}
}
\value{
Moran's I
}
\description{
\code{calculateMoranI} Moran's I computing method.
\deqn{
I = varOfInterest^t \times weightedM \times varOfInterest
}
}
\examples{
inputFileName<-system.file("testdata", "chen.csv", package="Irescale")
input<-loadFile(inputFileName)
distM<-calculateEuclideanDistance(input$data)
I<-calculateMoranI(distM = distM,varOfInterest = input$varOfInterest)
}
\references{
{
\insertAllCited{}
}
}
