% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rectifiedI.R
\name{calculateLocalI}
\alias{calculateLocalI}
\title{Computing the Local Moran's I}
\usage{
calculateLocalI(z, distM, scaling = TRUE)
}
\arguments{
\item{z}{vector with the var of interest}

\item{distM}{distance matrix}

\item{scaling}{to scale the variable of interest. The default value is set to TRUE}
}
\value{
a vector with the local Moran's I
}
\description{
\code{calculateLocalI} calculates the local Moran's I without rescaling
}
\examples{
fileInput <- system.file("testdata", "chen.csv", package="Irescale")
input <- loadFile(fileInput)
distM<-calculateEuclideanDistance(input$data)
localI<-calculateLocalI(input$varOfInterest,distM)
}
