% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-nrow.R
\docType{methods}
\name{nrow}
\alias{nrow}
\alias{nrow,IntervalMatrix-method}
\title{Get the number of rows of an \code{IntervalMatrix} object}
\usage{
\S4method{nrow}{IntervalMatrix}(x)
}
\arguments{
\item{x}{A matrix of interval-valued data stored as
an \code{IntervalMatrix} object.}
}
\value{
This function returns a single numeric value indicating the number of
rows of an interval-valued matrix. Therefore, this function always
returns an \code{integer} object whose length is one.
}
\description{
This function allows to get the number
of rows of an interval-valued matrix.
}
\examples{
## Some nrow() examples

data1 <- matrix(c(0, 1, 2, 3, 0, 3, 4, 9), 2, 4)
m1 <- IntervalMatrix(data1)
nrow(m1)
data2 <- matrix(c(1, 5, 3, 2, 6, 4, 0, 1, 3,
                  2, 3, 9, 4, 3, 7, 5, 6, 8), 3, 6)
m2 <- IntervalMatrix(data2)
nrow(m2)
}
\seealso{
The number of rows of an \code{IntervalMatrix} object can be obtained along
with the number of columns through \code{\link{dim}()} function. In an
analogous way, for getting the number of columns of an \code{IntervalMatrix}
object, \code{\link{ncol}()} function can be used.
}
\author{
José García-García \email{garciagarjose@uniovi.es}
}
