% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ibs.R
\name{ibs}
\alias{ibs}
\title{Integration for B-splines}
\usage{
ibs(x, knots = NULL, ord = 4, coef = rep(1, length(knots) - ord))
}
\arguments{
\item{x}{Numerical value or vector. The value(s) at which to evaluate the integral of the B-spline; must be in the bewteen min(knots) and max(knots).}

\item{knots}{A numeric vector of knot positions.}

\item{ord}{An integer >=1. The order of the B-spline integrand function to be integrated. Equals degree plus 1.}

\item{coef}{A numerical vector. The coefficients (de Boor points) defining the B-spline integrand function.}
}
\value{
A numerical equal to the integral(s).
}
\description{
Calculate the integral of a B-spline function.
}
\details{
The function returns the integral(s) of the B-spline function specified by knots knots, order ord, and coefficients coef, from the minimum knot position to each x value. The evaluation is based on a closed form expression of the integral in terms of higher order B-splines, given on page 128 of de Boor (2001).
}
\examples{
library(splines)
f <- function(x) x + 2 * x^2 - 3 * x^3 
n <- 200
set.seed(123)
x <- runif(n)
y <- f(x) + rnorm(n, sd = 0.1)
kns <- c(rep(0, 4), 1:4 * 0.2, rep(1, 4))
bs.c <- splineDesign(kns, x, 4)
coeff <- as.matrix(lm(y ~ bs.c-1)$coefficients)
f.b <- function(x, coeff) splineDesign(kns, x, 4) \%*\% coeff
integrate(f.b, 0, 1, coeff)
ibs(1,kns,4,coeff)
integrate(f, 0, 1)
plot(x,y)
curve(f(x), add = TRUE)
points(x,fitted(lm(y~bs.c-1)),col="blue",lty=1)
}
\references{
de Boor, C (2001)  \emph{A Practical Guide to Splines}. New York: Springer.
}

