% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cusum.transform.R
\name{cusum.transform}
\alias{cusum.transform}
\title{CUSUM transformation}
\usage{
cusum.transform(x)
}
\arguments{
\item{x}{input matrix}
}
\value{
The transformed matrix is returned. Note that the returned matrix has the same number of rows but one fewer columns compared with the input matrix.
}
\description{
Performing CUSUM transformation to the input matrix of multivariate time series. If the input is a vector, it is treated as a matrix of one row.
}
\details{
For any integers p and n, the CUSUM transformation \eqn{T_{p,n}: R^{p\times n}\to R^{p\times (n-1)}} is defined by
\deqn{
   [T_{p,n}(M)]_{j,t} := \sqrt{t(n-t)/n}\biggl(\frac{1}{n-t}\sum_{r=t+1}^n M_{j,r} - \frac{1}{t}\sum_{r=1}^t M_{j,r}\biggr).
}
}
\examples{
x <- matrix(rnorm(20),4,5)
cusum.transform(x)
}
