% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Inquilab.R
\name{plot_first_order_kinetics}
\alias{plot_first_order_kinetics}
\title{Plot for First Order Kinetics}
\usage{
plot_first_order_kinetics(t, c, kinetic_model)
}
\arguments{
  \item{t}{Numeric vector of time points.}
  \item{c}{Numeric vector of concentrations corresponding to each time point.}
  \item{kinetic_model}{Model object, result of lm function fitting log(c) ~ t.}
}
\description{
This function plots the actual and predicted concentrations based on first-order kinetics.
}
\value{
This function generates a plot of the actual vs. predicted concentrations based on the provided kinetic model and data points. The plot is rendered directly to the active plotting device.
}
\examples{
t <- c(0, 5, 10, 15, 20, 25)
c <- c(100, 80, 60, 40, 20, 10)
model <- lm(log(c) ~ t)
plot_first_order_kinetics(t, c, model)
}

