% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvm_2series.R
\name{cvm_2series}
\alias{cvm_2series}
\title{Cramer-von Mises Moebius statistics for testing independence between the innovations of 2 series of same length}
\usage{
cvm_2series(x, y, lag, graph = TRUE)
}
\arguments{
\item{x}{Pseudo-observations (or residuals) of first series}

\item{y}{Pseudo-observations (or residuals) of second series}

\item{lag}{Maximum number of lags around 0}

\item{graph}{Set to TRUE for a dependogram for all possible lags.}
}
\value{
\item{cvm}{Cramer-von Mises statistics for all lags}

\item{Wstat}{Sum of (unbiased) Cramer-von Mises statistics}

\item{Fstat}{Combination of p-values of the Cramer-von Mises statistics}

\item{pvalue}{List of p-values for the cvm, Wstat, and Fstat}
}
\description{
This function computes the Cramer-von Mises statistics between x(t) and y(t-l), for l=-lag,.., lag, and also the combinations of the p-values of these statistics.
}
\examples{
data(gas)
out <-cvm_2series(gas$xres,gas$yres,3)

}
\references{
Duchesne, Ghoudi & Remillard  (2012). On Testing for independence between the innovations of several time series. CJS, vol. 40, 447-479.
}
