% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Immigrate.R
\name{Immigrate}
\alias{Immigrate}
\title{Immigrate}
\usage{
Immigrate(
  xx,
  yy,
  w0,
  epsilon = 0.01,
  sig = 1,
  max_iter = 10,
  removesmall = FALSE,
  randomw0 = FALSE
)
}
\arguments{
\item{xx}{model matrix of explanatory variables}

\item{yy}{label vector}

\item{w0}{initial weight matrix, default to be diagonal matrix when missing}

\item{epsilon}{criterion for stopping iteration}

\item{sig}{sigma used in algorithm, default to be 1. Refer to the cost function in the link below for more details}

\item{max_iter}{maximum number of iteration}

\item{removesmall}{whether to remove features with small weights, default to be FALSE}

\item{randomw0}{whether to use randomly initial weights, default to be FALSE}
}
\value{
\item{w}{weight matrix obtained by IMMIGRATE algorithm}

\item{iter_num}{number of iteration for convergence}

\item{final_c}{final cost value. Refer to the cost function in link below for more details}
}
\description{
This function performs IMMIGRATE(Iterative Max-Min Entropy Margin-Maximization with Interaction Terms ) algorithm.
IMMIGRATE is a hypothesis-margin based feature selection method with interaction terms.
Its weight matrix reflects the relative importance of features and their iteractions, which can be used for feature selection.
}
\examples{
data(park)
xx<-park$xx
yy<-park$yy
re<-Immigrate(xx,yy)
print(re)
}
\references{
Zhao, Ruzhang, Pengyu Hong, and Jun S. Liu. "IMMIGRATE: A Margin-based Feature Selection Method with Interaction Terms." Entropy 22.3 (2020): 291.
}
\seealso{
Please refer to \url{https://www.mdpi.com/1099-4300/22/3/291/htm} for more details.

Please refer to \url{https://github.com/RuzhangZhao/Immigrate/} for implementation demo.
}
\keyword{Immigrate}
