% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IVPP.R
\name{IVPP_tsgvar}
\alias{IVPP_tsgvar}
\title{The invariance partial pruning (IVPP) algorithm for idiographic GVAR models}
\usage{
IVPP_tsgvar(
  data,
  vars,
  idvar,
  dayvar,
  beepvar,
  global = TRUE,
  g_test_net = c("both", "temporal", "contemporaneous"),
  net_type = c("sparse", "saturated"),
  output_equal = FALSE,
  partial_prune = FALSE,
  prune_net = c("both", "temporal", "contemporaneous"),
  prune_alpha = 0.01,
  p_prune_alpha = 0.01,
  estimator = "FIML",
  standardize = c("none", "z", "quantile"),
  ncores = 1,
  ...
)
}
\arguments{
\item{data}{A data frame containing the long-formatted panel data}

\item{vars}{A character vector of variable names}

\item{idvar}{A character string specifying the IDs of subjects you want to compare}

\item{dayvar}{A character string specifying the name of day variable}

\item{beepvar}{A character string specifying the name of variable indicating the measurement number at each day}

\item{global}{A logical value default to TRUE. If FALSE, the global invariance test is skipped.}

\item{g_test_net}{A character vector specifying the network you want to test group-equality on in the global invariance test.
Specify "both" if you want to test on both temporal or contemporaneous networks.
Specify "temporal" if you want to test only on the temporal network.
Specify "contemporaneous" if you want to test only on the contemporaneous network.
See the Details section for more information.}

\item{net_type}{A character vector specifying the type of networks to be compared in the global test.
Specify "saturated" if you want to estimate and compare the saturated networks.
Specify "sparse" if you want to estimate and compare the pruned networks.}

\item{output_equal}{Whether to output the networks that are constrained equal across groups.
Default to FALSE. Can set to TRUE if the global tests rejects heterogeneity.}

\item{partial_prune}{A logical value specifying whether to conduct partial pruning test or not.}

\item{prune_net}{A character vector specifying the network you want to partial prune on. Only works when partial_prune = TRUE.}

\item{prune_alpha}{A numeric value specifying the alpha level for the pruning (if net_type = "sparse").}

\item{p_prune_alpha}{A numeric value specifying the alpha level for the partial pruning (if partial_prune = TRUE).}

\item{estimator}{A character string specifying the estimator to be used. Must be "FIML"}

\item{standardize}{A character string specifying the type of standardization to be used.
"none" (default) for no standardization, "z" for z-scores,
and "quantile" for a non-parametric transformation to the quantiles of the marginal standard normal distribution.}

\item{ncores}{A numeric value specifying the number of cores you want to use to run the analysis. Default to 1.}

\item{...}{Additional arguments to be passed to the \code{\link[psychonetrics]{dlvm1}} function}
}
\value{
A list containing the results of IVPP and networks of all groups.
}
\description{
This function implements the IVPP algorithm to compare networks in the multi-group panelGVAR models.
The IVPP algorithm is a two-step procedure that first conducts an global invariance test of network difference and then performs partial pruning for the specific edge-level differences.
Currently supports the comparison of temporal and contemporaneous networks.
}
\details{
The comparison between the fully unconstrained (free) model and tempEq model is a test for group equality in temporal networks.
The comparison between fully constrained model (bothEq) and tempEq is a test for group equality in contemporaneous networks.
Similarly, the comparison between the free model and contEq model is a test for group equality in contemporaneous networks,
and the comparison between bothEq and contEq is a test for group equality in temporal networks.
}
\examples{
\donttest{
library(IVPP)

# Generate the network
net_ls <- gen_tsGVAR(n_node = 6,
                     p_rewire_temp = 0.5,
                     p_rewire_cont = 0.5,
                     n_persons = 2)

# Generate the data
data <- sim_tsGVAR(beta_base_ls = net_ls$beta,
                   kappa_base_ls = net_ls$kappa,
                   # n_person = 2,
                   n_time = 100)

# global test on temporal
omnibus_temp <- IVPP_tsgvar(data,
                            vars = paste0("V",1:6),
                            idvar = "id",
                            g_test_net = "temporal",
                            net_type = "sparse",
                            partial_prune = FALSE,
                            ncores = 1)

# global test on cont
omnibus_cont <- IVPP_tsgvar(data,
                            vars = paste0("V",1:6),
                            idvar = "id",
                            g_test_net = "contemporaneous",
                            net_type = "sparse",
                            partial_prune = FALSE,
                            ncores = 1)

# partial prune on both networks
pp_both <- IVPP_tsgvar(data,
                       vars = paste0("V",1:6),
                       idvar = "id",
                       global = FALSE,
                       partial_prune = TRUE,
                       prune_net = "both",
                       ncores = 1)
}
}
\author{
Xinkai Du
Maintainer: Xinkai Du \href{mailto:xinkai.du.xd@gmail.com}{xinkai.du.xd@gmail.com}
}
