#' Graven dataset for delta-delta calculation
#'
#' @description Atmospheric 14C and 13C data for the period 1850-2016. 
#' @details Data from Graven et al., 2017. Annual timestep. Three zones for 14C: 1) northern hemisphere, "NHc14" > 30 deg N, 2) southern hemisphere, "SHc14" > 30 deg S, 3) tropics, "Tropicsc14" < 30 deg N & < 30 deg S. 13C data are the global annual averages. 
#' @usage data(Graven_2017)
#' @references  Graven, H., Allison, C. E., Etheridge, D. M., Hammer, S., Keeling, R. F., Levin, I., Meijer, H. A. J., Rubino, M., Tans, P. P., Trudinger, C. M., Vaughn, B. H., and White, J. W. C.: Compiled records of carbon isotopes in atmospheric CO2 for historical simulations in CMIP6, Geosci. Model Dev., 10, 4405–4417, https://doi.org/10.5194/gmd-10-4405-2017, 2017. 
#'
#' @format dataframe

"Graven_2017"
