% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asthistibble.R
\name{asthistibble}
\alias{asthistibble}
\title{Copy tibble attributes}
\usage{
asthistibble(tibble, x)
}
\arguments{
\item{tibble}{a tibble object.}

\item{x}{a data frame with the same columns of \code{tibble}.}
}
\value{
A tibble.
}
\description{
Converts a data frame into a tibble copying all attributes.
}
\examples{
# tibble generated by haven
input <- system.file("extdata/reds", package = "ILSAmerge")
tib <- do.call(rbind,justload(inputdir = input,population = "BCGV1"))

# Remove all tibble attributes
x <- tib
class(x) <- "data.frame"
for(i in 1:ncol(x)){
  attributes(x[,1]) <- NULL
}

# Mix variables 
set.seed(1919)
x <- x[,sample(ncol(x))]
head(x)[,1:10]
tib

asthistibble(tibble = tib, x = x)

}
\keyword{tibblemanagement}
