% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IFconversion.r
\name{IFconversion}
\alias{IFconversion}
\title{Aggregation of primary data into Intuitionistic Representation}
\usage{
IFconversion(
  primary,
  u = round(mean(c(min(primary[, -1], na.rm = TRUE), max(primary[, -1], na.rm =
    TRUE)))),
  u_is_neutral = TRUE
)
}
\arguments{
\item{primary}{dataset with object names (not aggregated) in first column}

\item{u}{cut level}

\item{u_is_neutral}{if exact value of variable is equal to u (cut_level) the variable is treated as neutral (TRUE) or negative (FALSE)}
}
\value{
\code{IFconversion} returns the decision matrix (\emph{m} x \emph{n*3}) with the values of the \emph{mi} \emph{ni} and \emph{pi} (three columns for each fuzzy representation), for the \emph{n} criteria
}
\description{
The \code{IFconversion} - Aggregation of primary data into Intuitionistic Representation. Reference describing the method: Jefmański (2020) \doi{10.1007/978-3-030-52348-0_4}
}
\examples{
set.seed(61222)
data<-sample(1:7,26*13*8,replace=TRUE)
dim(data)<-c(26*13,8)
nrColumns<-8
primary<-data.frame(name=rep(LETTERS,each=13),data)
inth<-IFconversion(primary)
}
\references{
Jefmański Bartłomiej, Intuitionistic Fuzzy Synthetic Measure for Ordinal Data. in: Classification and Data Analysis: Theory and Applications / Jajuga Krzysztof, Batóg Jacek, Walesiak Marek (eds.), Studies in Classification, Data Analysis, and Knowledge Organization, 2020, Cham, Springer, 53-72. \doi{10.1007/978-3-030-52348-0_4}
}
