% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getIFD.R
\name{getIFD}
\alias{getIFD}
\title{RIF/CIF Image Field Directories Extraction}
\source{
TIFF 6.0 specifications archived from web \url{https://web.archive.org/web/20211209104854/https://www.adobe.io/open/standards/TIFF.html}
}
\usage{
getIFD(
  fileName,
  offsets = "first",
  trunc_bytes = 12,
  force_trunc = FALSE,
  verbose = FALSE,
  verbosity = 1,
  display_progress = FALSE,
  bypass = FALSE,
  ...
)
}
\arguments{
\item{fileName}{path to file.}

\item{offsets}{either "all", "first" or an object of class `IFC_offset`. Default is "first".}

\item{trunc_bytes}{a positive integer maximal number of individual scalar to extract BYTE/ASCII/SBYTE/UNDEFINED for TAGS (1, 2, 6 or 7). Default is 12.\cr
However, if less is found, less is returned in map. 
Note that, if 0 is provided, it will be automatically set to 1.}

\item{force_trunc}{whether to force truncation for all TAGS types. Default is FALSE.\cr
If TRUE, 'trunc_bytes' will be used for TAGS (3, 4, 5, 8, 9, 10, 11 and 12) to extract desired number of individual scalar corresponding to each types.}

\item{verbose}{whether to display information (use for debugging purpose). Default is FALSE.}

\item{verbosity}{quantity of information displayed when verbose is TRUE; 1: normal, 2: rich. Default is 1.}

\item{display_progress}{whether to display a progress bar. Default is FALSE.}

\item{bypass}{whether to bypass checks on 'trunc_bytes', 'force_trunc', 'verbose', 'verbosity' and 'display_progress'. Default is FALSE.}

\item{...}{other arguments to be passed.}
}
\value{
A list of named lists, each containing:\cr
-tags, a named list whose names are tags found, where each tag is a list of tag, typ, siz, val, byt, len, off, map information.\cr
-infos, a named list containing essential information about IFDs,
IMAGE_LENGTH, IMAGE_WIDTH, OBJECT_ID, COMPRESSION,
TYPE, STRIP_OFFSETS, STRIP_BYTE_COUNTS,
BG_MEAN, BG_STD\cr
-curr_IFD_offset, the position of current IFD offset\cr
-next_IFD_offset, the position of next IFD offset
}
\description{
Extracts IFDs (Image File Directory) in RIF or CIF files.\cr
IFDs contain information about images or masks of objects stored within XIF files.\cr
The first IFD is special in that it does not contain image of mask information but general information about the file.\cr
Users are highly encouraged to read TIFF specifications to have a better understanding about what IFDs are.
}
\details{
Function will return IFDs (image, mask or first) from the file using provided offsets argument.\cr
IFDs contain several tags that can be viewed as descriptive meta-information of raw data stored within RIF or CIF file. For more details see TIFF specifications.\cr
If 'offsets' == "first" only first IFD will be returned.\cr
If 'offsets' == "all" all images and masks IFDs will be returned but not "first" one.
Be aware that errors may occur if offsets are not extracted with \code{\link{getOffsets}} or \code{\link{subsetOffsets}}.
}
\examples{
if(requireNamespace("IFCdata", quietly = TRUE)) {
  ## use a cif file
  file_cif <- system.file("extdata", "example.cif", package = "IFCdata")
  ## read 1st IFD
  IFD_first <- getIFD(fileName = file_cif, offsets = "first")
  ## show information contained in 1st IFD
  print(sapply(IFD_first[[1]]$tags, FUN=function(x) x)) 
} else {
  message(sprintf('Please run `install.packages("IFCdata", repos = "\%s", type = "source")` \%s',
                  'https://gitdemont.github.io/IFCdata/',
                  'to install extra files required to run this example.'))
}
}
