% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_add_regions.R
\name{data_add_regions}
\alias{data_add_regions}
\title{Add Region to IFC_data Object}
\usage{
data_add_regions(obj, regions, ...)
}
\arguments{
\item{obj}{an `IFC_data` object extracted by ExtractFromDAF(extract_features = TRUE) or ExtractFromXIF(extract_features = TRUE).}

\item{regions}{a list of region(s) to add to obj. Each element of this list will be coerced by \code{\link{buildRegion}}.}

\item{...}{Other arguments to be passed.}
}
\value{
an IFC_data object with regions added.
}
\description{
Adds regions to an already existing `IFC_data` object.
}
\details{
A warning will be thrown if a provided region is already existing in 'obj'.\cr
In such a case this region will not be added to 'obj'.\cr
If any input population is not well defined and can't be created then an error will occur.
}
\examples{
if(requireNamespace("IFCdata", quietly = TRUE)) {
  ## use a daf file
  file_daf <- system.file("extdata", "example.daf", package = "IFCdata")
  daf <- ExtractFromDAF(fileName = file_daf)
  ## copy 1st region found in daf
  reg <- daf$regions[[1]]
  if(length(reg) != 0) {
    reg_copy <- reg
    ## modify region label and x boundaries
    reg_copy$label <- paste0(reg_copy$label,"_copy")
    reg_copy$x <- reg_copy$x*0.9
    ## create new object with this new region
    dafnew <- data_add_regions(obj = daf, regions = list(reg_copy))
  }
} else {
  message(sprintf('Please run `install.packages("IFCdata", repos = "\%s", type = "source")` \%s',
                  'https://gitdemont.github.io/IFCdata/',
                  'to install extra files required to run this example.'))
}
}
