% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExtractToFuns.R
\name{ExtractImages_toMatrix}
\alias{ExtractImages_toMatrix}
\title{Shortcut for Batch Images Extraction to Matrices/Arrays}
\usage{
ExtractImages_toMatrix(..., objects, offsets, display_progress = TRUE)
}
\arguments{
\item{\dots}{arguments to be passed to \code{\link{objectExtract}} with the exception of \code{'ifd'} and \code{'bypass'}(=\strong{TRUE}).\cr
\strong{/!\\} If not any of \code{'fileName'}, \code{'info'} and \code{'param'} can be found in \code{'...'} then \code{attr(offsets, "fileName_image")} will be used as \code{'fileName'} input parameter to pass to \code{\link{objectParam}}.}

\item{objects}{integer vector, IDEAS objects ids numbers to use.
This argument is not mandatory, if missing, the default, all objects will be used.}

\item{offsets}{object of class `IFC_offset`.
This argument is not mandatory but it may allow to save time for repeated image export on same file.\cr
If \code{'offsets'} are not provided, extra arguments can also be passed with \code{'...'} to \code{\link{getOffsets}}.}

\item{display_progress}{whether to display a progress bar. Default is TRUE.}
}
\value{
A list of matrices/arrays of images corresponding to objects extracted.
}
\description{
Function to shortcut extraction, normalization and eventually colorization of images to matrix ! excludes mask.
}
\details{
If \code{'param'} is provided in \code{'...'}, \code{'param$export'<-"matrix"} \strong{only} will be overwritten.
}
\note{
Arguments of \code{\link{objectExtract}} will be deduced from \code{\link{ExtractImages_toMatrix}} input arguments.
}
