% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Finalised_coding.R
\name{ID_pcm}
\alias{ID_pcm}
\title{Multiple change-point detection in the mean of a vector using the
Isolate-Detect methodology}
\usage{
ID_pcm(x, thr_id = 1, th_ic_id = 0.9, pointsth = 3, pointsic = 10)
}
\arguments{
\item{x}{A numeric vector containing the data in which you would like to find
change-points.}

\item{thr_id}{A positive real number with default value equal to 1. It is
used to define the threshold, if the thresholding approach is to be followed; see \code{\link{pcm_th}}
for more details.}

\item{th_ic_id}{A positive real number with default value equal to 0.9. It is
useful only if the model selection based Isolate-Detect method is to be followed.
It is used to define the threshold value that will be used at the first step
(change-point overestimation) of the model selection approach described in \code{\link{pcm_ic}}.}

\item{pointsth}{A positive integer with default value equal to 3. It is used only
when the threshold based approach is to be followed and it defines the distance
between two consecutive end- or start-points of the right- or left-expanding intervals,
respectively.}

\item{pointsic}{A positive integer with default value equal to 10. It is used only
when the information criterion based approach is to be followed and it defines
the distance between two consecutive end- or start-points of the right- or
left-expanding intervals, respectively.}
}
\value{
A list with the following components:
   \tabular{ll}{
   \cr \code{cpt} \tab A vector with the detected change-points.
   \cr \code{no_cpt}    \tab The number of change-points detected.
   \cr \code{fit} \tab A numeric vector with the estimated piecewise-constant signal.
   \cr \code{solution_path} \tab A vector containing the solution path.
  }
}
\description{
This function estimates the number and locations of multiple change-points in the mean
of the noisy piecewise-constant input vector \code{x}, using the Isolate-Detect methodology. The noise
is Gaussian. The estimated signal, as well as the solution path defined in \code{\link{sol_path_pcm}} are
also given. The function is a hybrid between the thresholding approach of \code{\link{win_pcm_th}} and the
information criterion approach of \code{\link{pcm_ic}} and estimates the change-points taking into
account both these approaches (see Details for more information and the relevant literature reference).
}
\details{
Firstly, this function detects the change-points using \code{\link{win_pcm_th}}.
  If the estimated number of change-points is larger than 100, then the
  result is returned and we stop. Otherwise, \code{\link{ID_pcm}} proceeds to detect the
  change-points using \code{\link{pcm_ic}} and this is what is returned. To sum up,
  \code{\link{ID_pcm}} returns a result based on \code{\link{pcm_ic}} if the estimated number
  of change-points is less than 100. Otherwise, the result comes from thresholding.
  More details can be found in ``Detecting multiple generalized change-points by
  isolating single ones'', Anastasiou and Fryzlewicz (2018), preprint.
}
\examples{
single.cpt <- c(rep(4,1000),rep(0,1000))
single.cpt.noise <- single.cpt + rnorm(2000)
cpts_detect <- ID_pcm(single.cpt.noise)

three.cpt <- c(rep(4,500),rep(0,500),rep(-4,500),rep(1,500))
three.cpt.noise <- three.cpt + rnorm(2000)
cpts_detect_three <- ID_pcm(three.cpt.noise)

multi.cpt <- rep(c(rep(0,50),rep(3,50)),20)
multi.cpt.noise <- multi.cpt + rnorm(2000)
cpts_detect_multi <- ID_pcm(multi.cpt.noise)
}
\seealso{
\code{\link{win_pcm_th}} and \code{\link{pcm_ic}} which are the functions that \code{\link{ID_pcm}}
is based on. In addition, see \code{\link{ID_cplm}} for the case of detecting changes
in a continuous, piecewise-linear signal. The main function \code{\link{ID}}
of the package employs \code{\link{ID_pcm}}.
}
\author{
Andreas Anastasiou, \email{a.anastasiou@lse.ac.uk}
}
