% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapperfuncs.r
\name{get.cross.PCF}
\alias{get.cross.PCF}
\title{Cross type Pair Correlation Function using homotypic and heterotypic case types}
\usage{
get.cross.PCF(epi.data, type, hom, het = NULL, r = NULL, correction = "none")
}
\arguments{
\item{epi.data}{a three-column numerical matrix that contains coordinates (\code{x} and \code{y}) for each case and information on case type (e.g. genotype or serotype). First two columns must be \code{x} and \code{y}}

\item{type}{an integer giving the column that contains information on case type. Must be an integer or a character}

\item{hom}{a scalar or vector giving the homotypic case type(s). Equivalent to the 'j' point type used in the cross K function. Must be an integer or character}

\item{het}{a scalar or vector giving the heterotypic case type(s). Equivalent to the 'i' point type used in the cross K function. The default is \code{NULL}, which uses any case type not defined in the \code{hom} argument as heterotypic. Must be an integer or a character}

\item{r}{a numeric vector giving the spatial distances}

\item{correction}{type of edge correction to be applied (default set to 'none'). See the \link[spatstat.explore]{pcf} function in the \pkg{spatstat.explore} package for more details}
}
\value{
a data frame with two columns giving the radius \code{r}, the theoretical value of the Pair Correlation Function for a Poisson process (\code{theo}), and value of the Pair Correlation Function \code{pcf}
}
\description{
A wrapper function of the \link[spatstat.explore]{pcf} function from the \pkg{spatstat.explore} package (Baddeley et al. 2016) that takes epidemiological data used by \pkg{IDSpatialStats} functions and calculates the cross type Pair Correlation Function based on user defined case type homology
}
\examples{
data(DengueSimR01)

g <- get.cross.PCF(epi.data=DengueSimR01, type=5, hom=2, het=NULL, r=NULL, correction='none')

plot(g$pcf, type='l', xlab='r', ylab='cross PCF')
abline(h=1, col='red', lty=2)
}
\references{
Baddeley A, Rubak E, and Turner R. (2016). "Spatial Point Patterns: Methodology and Applications with R". CRC Press.
}
\author{
John Giles
}
