% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RooksGradient.R
\name{RooksGradient}
\alias{RooksGradient}
\title{Calculate Gradient Statistics in the Rook's Neighbourhood}
\usage{
RooksGradient(vfdf, statistic = "mean")
}
\arguments{
\item{vfdf}{A data frame as returned by \code{\link{SubgridStats}}}

\item{statistic}{desired output statistic: It should be one of "mean", "var",
or "sum". Default setting is mean.}
}
\value{
A data frame similar to vfdf except that it includes an additional
column called Gradient as described above.
}
\description{
The movement of populations into adjacent cells may sometimes be influenced
by the gradient of some predictive variable. This function enables the
calculation of a simple gradient statistic in the rook's neighbourhood of
each cell in a dataset. The statistic must first be computed for each grid
cell using \code{\link{SubgridStats}}. Then for each grid, the RooksGradient
function computes the arithmetic average of the difference between the
statistic at the focal grid cell and the statistic in the four (or fewer)
adjacent neighbours in its Rook's neibourhood. This arithmetically averaged
difference is then returned under the column header of 'Gradient'. A negative
gradient estimate indicates that the statistic in the central cell is higher
than that in neighbouring cells whereas a positive gradient estimate
indicates the opposite.
}
\examples{
# creating pattern patterns
Mat1 <- matrix(rep(0,9*9), nrow = 9)
Mat1[c(4:6), c(4:6)] <- 2
Mat1[c(4:6), c(1:3)] <- 1
Mat1[c(1:3), c(4:6)] <- 1
Mat1[c(7:9), c(4:6)] <- 1
Mat1[c(4:6), c(7:9)] <- 1
Mat1

Rast1 <- terra::rast(Mat1)
terra::plot(Rast1)

# calculating the mean in 9 subgrids
(statsdf1 <- SubgridStats(Rast1, factv1 = 3, facth1 = 3, statistic = "mean"))

# computing the gradient statistic on the mean
(graddf1 <- RooksGradient(statsdf1, statistic = "mean"))
# the Gradient statistic in the central grid in row 5 should
# be equal to negative one

}
