% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PatternDetect.R
\name{PatternDetect}
\alias{PatternDetect}
\title{Detect Patterns in Vector Fields}
\usage{
PatternDetect(vfdf)
}
\arguments{
\item{vfdf}{A data frame as returned by \code{\link{DispField}},
\code{\link{DispFieldST}}, or \code{\link{DispFieldSTall}} with at least
five rows (more is better)}
}
\value{
A data frame as returned by \code{\link{DispField}},
\code{\link{DispFieldST}}, or \code{\link{DispFieldSTall}}, with three
additional columns. The first additional column is called Pattern in which
the patterns around each focal cell are categorized as convergence,
divergence, partial convergence, partial divergence, or NA. The second
additional column, called SubPattern, indicates whether all arrows point
clockwise or counter-clockwise. The third additional column is called
PatternCt, which contains a one if all four neighbourhood grid cells
contain displacement estimates, and a NA otherwise.
}
\description{
Detect patterns in vector fields represented on a grid by looking in the
rook's neighbourhood of each grid cell. Four patterns are detected:
convergences occur when the vectors in the four adjacent cells in the rook's
neighbourhood point towards the focal cell; divergences occur when the
vectors in the four adjacent cells point away from the focal cell; Partial
convergences occur when three of the four vectors point towards the focal
cell and the final vector points neither towards nor away from the focal
cell; Partial divergences occur when three of the four vectors point away the
focal grid cell and the final vector points neither towards nor away from the
focal grid. For all of the patterns above a sub-pattern is specified if all
arrows point clockwise or counter-clockwise.
}
\examples{
# creating convergence/divergence patterns
Mat1 <- matrix(rep(0,9*9), nrow = 9)
Mat1[3, c(4, 6)] <- 1
Mat1[7, c(4, 6)] <- 1
Mat1[c(4, 6), 3] <- 1
Mat1[c(4, 6), 7] <- 1
Mat1

Mat2 <- matrix(rep(0,9*9), nrow = 9)
Mat2[2, c(4, 6)] <- 1
Mat2[8, c(4, 6)] <- 1
Mat2[c(4, 6), 2] <- 1
Mat2[c(4, 6), 8] <- 1
Mat2

# rasterizing
rast1 <- terra::rast(Mat1)
terra::plot(rast1)
rast2 <- terra::rast(Mat2)
terra::plot(rast2)

# Detecting a divergence
(VFdf1 <- DispField(rast1, rast2, factv1 = 3, facth1 = 3, restricted = TRUE))
(patdf1 <- PatternDetect(VFdf1))

# Detecting a convergence
(VFdf2 <- DispField(rast2, rast1, factv1 = 3, facth1 = 3, restricted = TRUE))
(patdf2 <- PatternDetect(VFdf2))
}
