% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ICV.R
\name{LocICV}
\alias{LocICV}
\title{The local ICV function.}
\usage{
LocICV(h, xest, x, eta, alpha, sigma)
}
\arguments{
\item{h}{bandwidth (scalar) in the final scale,}

\item{xest}{estimation point (scalar),}

\item{x}{numerical vector of data,}

\item{eta}{smoothing parameter,}

\item{alpha}{first parameter of the selection kernel,}

\item{sigma}{second parameter of the selection kernel.}
}
\value{
The value of the local ICV function at the fixed estimation point and for the specified value of the bandwidth (see Section 6 of Savchuk, Hart, and Sheather (2010)).
}
\description{
Computing the local ICV function at the given estimation point, as explained in Section 6 of Savchuk, Hart, and Sheather (2010).
}
\details{
Calculation of the local ICV function at the given estimation point xest. The Gaussian kernel is used for local weighting. The ultimate kernel density estimate is computed based on the Gaussian kernel. The parameters of the selection kernel \code{\link{L_ICV}} are \eqn{\alpha} and \eqn{\sigma}. The minimizer of the local ICV function is to be used in computing the ultimate density estimate without additional rescaling. Parameter \eqn{\eta} is a smoothing parameter that determines the degree to which the cross-validation is local. A suggested value of \eqn{\eta} is \eqn{\eta=R/20}, where \eqn{R} is the range of data.
}
\examples{
\dontrun{
# Local ICV function for a random sample of size n=150 from the kurtotic density of Marron and
# Wand (1992).
dat=mixnorm(150,c(2/3,1/3),c(0,0),c(1,1/10))
a=2.42   # alpha
s=5.06   # sigma
harg=seq(0.025,1,len=100)
Xest=0.1    # estimation point
LocICV_Xest=numeric(length(harg))
for(i in 1:length(harg))
  LocICV_Xest[i]=LocICV(harg[i],Xest,dat,0.2,a,s)
h_Xest=optimize(LocICV,c(0.001,0.2),tol=0.001,xest=Xest,eta=0.2,x=dat,alpha=a,sigma=s)$minimum
h_Xest=round(h_Xest,digits=4)
dev.new()
plot(harg,LocICV_Xest,'l',lwd=3,xlab="harg",ylab="LocICV_Xest",main="",cex.lab=1.7, cex.axis=1.7)
title(main=paste("Local ICV function at x=",Xest),cex.main=1.7)
legend(0.1,max(LocICV_Xest),legend=paste("h_x=",h_Xest),cex=1.7)
legend(0.2,max(LocICV_Xest)-0.15,legend="Note: first local minimizer is used", cex=1.5,bty="n")
}
}
\references{
\itemize{
  \item Savchuk, O.Y., Hart, J.D., Sheather, S.J. (2010). Indirect cross-validation for density estimation. \emph{Journal of the American Statistical Association}, 105(489), 415-423.
  \item Savchuk, O.Y., Hart, J.D., Sheather, S.J. (2009). An empirical study of indirect cross-validation. \emph{Nonparametric Statistics and Mixture Models: A Festschrift in Honor of Thomas P. Hettmansperger.} World Scientific Publishing, 288-308.
  \item Hall, P., and Schukany, W. R. (1989). A local cross-validation algorithm. \emph{Statistics and Probability Letters}, 8, 109-117.
}
}
\seealso{
\code{\link{h_ICV}}, \code{\link{C_ICV}}, \code{\link{L_ICV}}, \code{\link{MISE_mixnorm}}, \code{\link{ICV}}, \code{\link{KDE_ICV}}.
}

