% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icd_lookup.R
\name{icd_search}
\alias{icd_search}
\title{Search ICD-10-GM labels for a string}
\usage{
icd_search(pattern, level = 5, year = NULL, ignore.case = TRUE, ...)
}
\arguments{
\item{pattern}{String to search for (character object of length 1)}

\item{level}{Maximum level of the ICD-10 hierarchy to search. level = 3 will search ohne 3-digit codes, level = 4 all 3 and 4 digit codes, level = 5 will search through all codes.}

\item{year}{Year in which to search (Default: most recent year available)}

\item{ignore.case}{Should the search be case insensitive? (Default: TRUE)}

\item{...}{Further parameters passed to \code{agrep}}
}
\value{
Usually called for side-effect (open browser), returns the corresponding URL invisibly.
}
\description{
Search ICD-10-GM labels for a string
}
\examples{
icd_search("vitamin", level = 3)
icd_search("vitamin", level = 5)
}
\seealso{
\code{\link[=icd_browse]{icd_browse()}} to lookup an ICD-10-GM code in the official BfArM documentation, opening the page in a browser
\code{\link[=icd_lookup]{icd_lookup()}} to lookup an ICD-10-GM code in the console
}
