% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VCF_to_catalog_functions.R
\name{AddAndCheckDBSClassInVCF}
\alias{AddAndCheckDBSClassInVCF}
\title{Add and check DBS class in an annotated VCF with the corresponding DBS
mutation matrix}
\usage{
AddAndCheckDBSClassInVCF(vcf, mat78, mat136, mat144 = NULL, sample.id)
}
\arguments{
\item{vcf}{An in-memory VCF file annotated with sequence context and
transcript information by function \code{\link{AnnotateDBSVCF}}. It must
*not* contain indels and must *not* contain SBS (single base
substitutions), or triplet base substitutions etc.}

\item{mat78}{The DBS78 mutation count matrix.}

\item{mat136}{The DBS136 mutation count matrix.}

\item{mat144}{The DBS144 mutation count matrix.}

\item{sample.id}{Usually the sample id, but defaults to "count".}
}
\value{
The original \code{vcf} with three additional columns
  \code{DBS78.class}, \code{DBS136.class} and \code{DBS144.class} added.
}
\description{
Add and check DBS class in an annotated VCF with the corresponding DBS
mutation matrix
}
\keyword{internal}
