% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{weibull}
\alias{weibull}
\title{Weibull function.}
\usage{
weibull(k, lambda = 1)
}
\arguments{
\item{k}{Shape parameter, a positive real number.}

\item{lambda}{Scale parameter, a positive real number, defaults to 1.}
}
\value{
The Weibull density function \code{dweibull} with shape parameter \code{k} and scale parameter \code{lambda}, see \code{\link[stats]{dweibull}}.
}
\description{
The Weibull (density) function is defined as
\deqn{h(x) = \bigl(\frac{k}{\lambda}\bigr) {\bigl( \frac{x}{\lambda} \bigr)}^{k-1} e^{-(x/\lambda)^k}}
with \eqn{k, \lambda \in (0, +\infty)}.
}
\details{
A C++ version of this function is available. See \code{vignette('IBMPopSim_cpp')} for more details.
}
\seealso{
\url{https://en.wikipedia.org/wiki/Weibull_distribution}
}
