% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkBuilding.R
\name{hospinet_from_subject_database}
\alias{hospinet_from_subject_database}
\title{Create HospiNet object from subject database}
\usage{
hospinet_from_subject_database(
  base,
  window_threshold = 365,
  count_option = "successive",
  condition = "dates",
  prob_params = c(0.0036, 1/365, 0.128),
  noloops = TRUE,
  nmoves_threshold = NULL,
  flag_vars = NULL,
  flag_values = NULL,
  create_MetricsTable = TRUE,
  verbose = FALSE,
  shinySession = NULL,
  ...
)
}
\arguments{
\item{base}{(hospinet.base) A database of records of stays of subjects in
facilities. This can be obtained using the function \code{\link{checkBase}}.}

\item{window_threshold}{(numeric)
A threshold for the number of days between discharge and admission to be counted as a transfer. Set to 0 for same day transfer, default is 365 days.}

\item{count_option}{(character) TODO. Default is "successive".}

\item{condition}{(character) TODO. Default is "dates".}

\item{prob_params}{(vector of numeric) Three numerical values to calculate
the probability that a movement causes an introduction from hospital A
to hospital B. See Donker T, Wallinga J, Grundmann H. (2010) <doi:10.1371/journal.pcbi.1000715> for more details.
prob_params[1] is the rate of acquisition in hospital A (related to LOS
in hospital A). Default: 0.0036
prob_params[2] is the rate of loss of colonisation (related to time
between admissions). Default: 1/365
prob_params[4] is the rate of transmission to other patients in hospital
B (related to LOS in hospital B). Default: 0.128}

\item{noloops}{(boolean).
Should transfers within the same nodes (loops) be kept or set to 0. Defaults to TRUE, removing loops (setting matrix diagonal to 0).}

\item{nmoves_threshold}{(numeric)
A threshold for the minimum number of subject transfer between two facilities. Set to NULL to deactivate, default to NULL.}

\item{flag_vars}{(list) Additional variables that can help flag a transfer,
besides the dates of admission and discharge. Must be a named list of two
character vectors which are the names of the columns that can flag a
transfer: the column that can flag a potential origin, and the column
that can flag a potential target. The list must be named with "origin"
and "transfer". Eg: list("origin" = "var1", "target" = "var2"). See
details.}

\item{flag_values}{(list) A named list of two character vectors which contain
the values of the variables in flag_var that are matched to flag a
potential transfer. The list must be named with "origin" and
"transfer". The character vectors might be of length greater than
one. Eg: list("origin" = c("value1", "value2"), "target" = c("value2",
"value2")). The values in 'origin' and 'target' are the values that flag
a potential origin of a transfer, or a potential target,
respectively. See details.}

\item{create_MetricsTable}{(boolean)
Should the metrics table be created along with the network. Setting to FALSE will speed up the results. Default is TRUE.}

\item{verbose}{TRUE to print computation steps}

\item{shinySession}{(NULL) internal variable to deal with the progress bar}

\item{...}{Additional parameters to be sent to checkBase in case the database has not been checked yet.}
}
\value{
The function returns a HospiNet object.
}
\description{
This function creates a HospiNet object from the database containing subjects stays.
}
\details{
This function will build a HospiNet object from a line-listed
subject database. The HospiNet object has all of the functions stored as
active bindings which can be accessed in the usual way. For more info, see
\code{\link{HospiNet}}.
Note that the subject database will need to be run through \code{\link{checkBase}}
before going into this function.
}
\examples{
mydb <- create_fake_subjectDB(n_subjects = 100, n_facilities = 10)
myBase <- checkBase(mydb)
hospinet_from_subject_database(myBase)
}
\seealso{
\code{\link{HospiNet}}
}
