% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_HOMERTFs.R
\name{plot_HOMERTFs}
\alias{plot_HOMERTFs}
\title{Plot HOMER TF enrichment results}
\usage{
plot_HOMERTFs(
  dir = "/directory/of/results/",
  show = 3,
  qThreshold = 0.05,
  levenSimThreshold = 1
)
}
\arguments{
\item{dir}{string. Input directory containing HOMER findMotifsGenome.pl output files in format: *knownResults.txt}

\item{show}{int. Number of rows to show per input file, ranked by p-value.}

\item{qThreshold}{int. Value for thresholding HOMER enrichment results by q-value.}

\item{levenSimThreshold}{float. Value for thresholding TFs. For groups of TFs with similar consensus sequences, the TF with the lowest p-value by HOMER will be retained.}
}
\value{
ggplot object
}
\description{
Plot HOMER TF enrichment results
}
\details{
\subsection{Make bigTable of all TFs to pull from so a single TF can have data from different input Files (e.g. across CTs)}{

(5) Create bigTable of all q-value TF results concatenated together
(6) Filter by consensus list (4)and make a gg-plot appropriate table and Plot
(7-8) Order factors and plot
}
}
\section{Strategy:}{
\subsection{Find motifs to extract}{

(1) Filter each element table by q-value. Should basically chop off the bottom portion of list, making the rest of the script less computationally cumbersome
(2) Collapse each element table by by Levenshtein Similarity
(3) Filter each element table (in my case: cell type-specific results file) to top X rows
(4) Extract consensus columns from each element table and store as a variable]
}
}

\author{
Tim Scott
}
