% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/histogram.R
\name{sum,HistDat-method}
\alias{sum,HistDat-method}
\title{Calculates the sum of all observations in the histogram dataset}
\usage{
\S4method{sum}{HistDat}(x, ..., na.rm = FALSE)
}
\arguments{
\item{x}{An instance of the class HistDat}

\item{...}{Additional arguments to pass to \code{sum()}}

\item{na.rm}{Passed verbatim to \code{\link[base:sum]{base::sum()}}}
}
\value{
A numeric of length 1, holding the sum of all values in the dataset
}
\description{
Calculates the sum of all observations in the histogram dataset
}
\section{Functions}{
\itemize{
\item \code{sum,HistDat-method}: The S4 version
}}

\examples{
hd <- HistDat(vals = 1:3, counts = c(1, 2, 1))
sum(hd) # returns 8
}
