% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HighestMedianRules.R
\name{gauge}
\alias{gauge}
\title{Gauge}
\usage{
gauge(grades, k = 0.5, scale = c(), return = "qp")
}
\arguments{
\item{grades}{A numeric vector containing the shares of each grades of a candidate, from the lowest grade to the highest.}

\item{k}{The quantile used to compute the gauge. Default to 0.5 (the median). For more details, see paragraph Extensions in 3.2.1 of "Tie-Breaking the Highest Median", Fabre, Social Choice & Welfare (forthcoming).}

\item{scale}{A numeric vector containing the values of the scale of grades. Default to c((floor(-length(grades)/2)+1):(length(grades)+floor(-length(grades)/2))).}

\item{return}{A string containing the information to return. Default to 'qp' (shares of opponents and proponents). Possible values: 'g', 'p', 'q', 'pq', 'qp', 'qpg', 'pqg', 'gpq', 'gqp', 'text' (i.e. the gauge), 'all'. If the string does not match one of the above, 'all' is returned.}
}
\value{
A double, a character vector or a double vector. Depending on what is passed in \code{return}.
}
\description{
This function returns a custom description of the grades of a candidate in terms of the shares of proponents (p), opponents (q), median grades (g), and the gauge (i.e. the median grade followed by + or -, a + corresponding to a larger share of proponents than opponents).
}
\examples{
gauge(elec2012['Hollande',], return = 'gqp')
}
