% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenerateQCPlots.R
\name{GenerateQCPlots}
\alias{GenerateQCPlots}
\title{Generate quality control plots for mz pair candidates.}
\usage{
GenerateQCPlots(
  res_list = NULL,
  pdf_file = NULL,
  mfrow = NULL,
  skip_plots = NULL
)
}
\arguments{
\item{res_list}{A list of result objects (each testing an individual mz pair).}

\item{pdf_file}{The path to a writable file.}

\item{mfrow}{If NULL automatically determined, otherwise useful to specify a layout.}

\item{skip_plots}{NULL or numeric vector in which case plots with numbers in skip_plots will be empty.}
}
\value{
Figure output.
}
\description{
\code{GenerateQCPlots} will produce QC plots for a list
    containing test results objects (generated by \link{EvaluateCandidateListAgainstRawData}.
}
\details{
If you provide a single candidate (list of length = 1) an output to
    a screen plotting device is reasonable, otherwise a target PDF file should
    be specified in parameter `pdf_file`.
}
\examples{
\dontrun{
  # load evaluation result of example data
  data(res_list)
  # generate Figures on screen (use PDF output for multiple candidates)
  GenerateQCPlots(res_list[1])
}

}
