% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{PlotDoubleML}
\alias{PlotDoubleML}
\title{Plot Heterogeneity-seq DoubleML Results}
\usage{
PlotDoubleML(
  table,
  highlights = NULL,
  p.cutoff = 0.05,
  est.cutoff = NULL,
  highlights.color = NULL,
  label.repulsion = 1,
  density.color = TRUE,
  density.n = 500,
  point.scale = 0.5,
  xlab = "Estimate",
  ylab = bquote("-" ~ log[10] ~ FDR),
  linetype = "dashed"
)
}
\arguments{
\item{table}{Table from the Hetseq using the doubleML method.}

\item{highlights}{A vector of genes to highlight in the plot.}

\item{p.cutoff}{Adds a dashed horizontal line at the given adjusted p-value cutoff.}

\item{est.cutoff}{Adds two dashed vertical lines (+/-) at the given estimate cutoff.}

\item{highlights.color}{A vector of colors for gene highlights.}

\item{label.repulsion}{Represents the force parameter of the ggrepel::geom_label_repel() function. Higher values reduce label overlap.}

\item{density.color}{Color data points by density. Default is TRUE.}

\item{density.n}{Set granularity of 2d density color.}

\item{point.scale}{Set point size.}

\item{xlab}{Set label of the x-axis.}

\item{ylab}{Set label of the y-axis.}

\item{linetype}{Set the linetype of the p-value and estimate cutoff line.}
}
\value{
ggplot object.
}
\description{
This plotting functions creates a Vulcano Plot to visualize DoubleML Results.
}
\examples{
\donttest{
  tab <- HetseqDoubleML(data, trajectories, score.name = "score")
  PlotDoubleML(tab, highlights=c("MYC", "GAPDH", "ISG15"))
}
}
