% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FormatCompareAIC.R
\name{FormatCompareAIC}
\alias{FormatCompareAIC}
\title{Format data to be used with compare_AIC()}
\usage{
FormatCompareAIC(logLik, nobs, df)
}
\arguments{
\item{logLik}{The log likelihood}

\item{nobs}{Number of observations}

\item{df}{Number of parameters}
}
\value{
An object to be used with compare_AIC()
}
\description{
Format data to be used with compare_AIC(), compare_AICc() and compare_BIC().\cr
Note that logLik is supposed to not be -logLik.
}
\details{
FormatCompareAIC formats data to be used with compare_AIC()
}
\examples{
\dontrun{
ED <- FormatCompareAIC(logLik=-140, nobs=100, df=3)
L <- FormatCompareAIC(logLik=-145, nobs=100, df=4)
compare_AIC(L=L, ED=ED)
compare_AICc(L=L, ED=ED)
compare_BIC(L=L, ED=ED)
}
}
\seealso{
Other AIC: 
\code{\link{ExtractAIC.glm}()},
\code{\link{compare_AIC}()},
\code{\link{compare_AICc}()},
\code{\link{compare_BIC}()}
}
\author{
Marc Girondot \email{marc.girondot@gmail.com}
}
\concept{AIC}
