% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geraHeckman.R
\name{geraHeckman}
\alias{geraHeckman}
\title{Generating Heckman data  : Normal, Student-t, Slash and Laplace}
\usage{
geraHeckman(x, w, beta, gamma, sigma2, rho, nu, family = "T")
}
\arguments{
\item{x}{A covariate matrix for the response y.}

\item{w}{A covariate matrix for the missing indicator cc.}

\item{beta}{Values for the beta vector.}

\item{gamma}{Values for the gamma vector.}

\item{sigma2}{Value for the variance.}

\item{rho}{Value for the dependence between the response and missing value.}

\item{nu}{When using the t- distribution, the initial value for the degrees of freedom.}

\item{family}{The distribution family to be used (Normal, T, or CN).}
}
\value{
Return an object with the response (y) and missing values (cc).
}
\description{
`geraHeckman()` generates a random sample from the Heckman selection model (Normal, Student-t or CN).
}
\examples{
\donttest{
n <- 100
rho <- .6
cens <- 0.25
nu <- 4
set.seed(20200527)
w <- cbind(1,runif(n,-1,1),rnorm(n))
x <- cbind(w[,1:2])

family <- "T"
c <- qt(cens, df=nu)

sigma2 <- 1
beta <- c(1,0.5)
gamma<- c(1,0.3,-.5)
gamma[1] <- -c*sqrt(sigma2)

data <- geraHeckman(x,w,beta,gamma,sigma2,rho,nu,family=family)
}
}
\references{
Lachos, V. H., Prates, M. O., & Dey, D. K. (2021).
 Heckman selection-t model: Parameter estimation via the EM-algorithm.
 Journal of Multivariate Analysis, 184, 104737.
}
