% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HeckmanEM.R
\name{HeckmanEM}
\alias{HeckmanEM}
\title{Fit the Normal, Student-t or Contaminated normal Heckman Selection model}
\usage{
HeckmanEM(
  y,
  x,
  w,
  cc,
  nu = 4,
  family = "T",
  error = 1e-05,
  iter.max = 500,
  im = TRUE,
  criteria = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{y}{A response vector.}

\item{x}{A covariate matrix for the response y.}

\item{w}{A covariate matrix for the missing indicator cc.}

\item{cc}{A missing indicator vector (1=observed, 0=missing) .}

\item{nu}{When using the t- distribution, the initial value for the degrees of freedom.
When using the CN distribution, the initial values for the proportion of bad observations and the degree of contamination.}

\item{family}{The family to be used (Normal, T or CN).}

\item{error}{The absolute convergence error for the EM stopping rule.}

\item{iter.max}{The maximum number of iterations for the EM algorithm.}

\item{im}{TRUE/FALSE, boolean to decide if the standard errors of the parameters should be computed.}

\item{criteria}{TRUE/FALSE, boolean to decide if the model selection criteria should be computed.}

\item{verbose}{TRUE/FALSE, boolean to decide if the progress should be printed in the screen.}
}
\value{
An object of the class HeckmanEM with all the outputs provided from the function.
}
\description{
`HeckmanEM()` fits the Heckman selection model.
}
\examples{
n    <- 100
nu   <- 3
cens <- 0.25

set.seed(13)
w <- cbind(1,runif(n,-1,1),rnorm(n))
x <- cbind(w[,1:2])
c <- qt(cens, df=nu)

sigma2   <- 1
beta     <- c(1,0.5)
gamma    <- c(1,0.3,-.5)
gamma[1] <- -c*sqrt(sigma2)

set.seed(1)
datas <- rHeckman(x,w,beta,gamma,sigma2,rho = 0.6,nu,family="T")
y <- datas$y
cc <- datas$cc
\donttest{
# Normal EM
res.N <- HeckmanEM(y, x, w, cc, family="Normal",iter.max = 50)
# Student-t EM
res.T <- HeckmanEM(y, x, w, cc, nu = 4, family="T", iter.max = 50)
}
}
