% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assembly.R
\name{hapiAssemble}
\alias{hapiAssemble}
\title{Consensus haplotype assembly}
\usage{
hapiAssemble(gmt, draftHap, keepLowConsistency = TRUE,
  consistencyThresh = 0.85)
}
\arguments{
\item{gmt}{a dataframe of genotype data of gamete cells}

\item{draftHap}{a dataframe with draft haplotype information}

\item{keepLowConsistency}{logical, if low-consistent gamete cells 
should be kept}

\item{consistencyThresh}{a numeric value of the threshold determining 
low-consistent gamete cells compared with the draft haplotype. 
Default is 0.85}
}
\value{
a dataframe containing phased haplotypes
}
\description{
Assemble the consensus high-resolution haplotypes
}
\examples{
finalDraft <- rep(0,500)
names(finalDraft) <- seq_len(500)

ref <- rep(0,500)
alt <- rep(1,500)

gmtDa <- data.frame(gmt1=ref, gmt2=alt, gmt3=ref,
gmt4=ref, gmt5=c(alt[1:250], ref[251:500]),
stringsAsFactors = FALSE)

idx1 <- sort(sample(seq_len(500), 30, replace = FALSE))
idx2 <- sort(sample(seq_len(500), 30, replace = FALSE))
idx3 <- sort(sample(seq_len(500), 30, replace = FALSE))

gmtDa[idx1,1] <- NA
gmtDa[idx2,2] <- NA
gmtDa[idx3,3] <- NA

consensusHap <- hapiAssemble(draftHap = finalDraft, gmt = gmtDa)
}
\author{
Ruidong Li
}
