% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_SortGeoData.R
\name{SortGeoData}
\alias{SortGeoData}
\title{Sort a GeoData dataframe in downstream order}
\usage{
SortGeoData(gd, bd = NULL, progbar = TRUE)
}
\arguments{
\item{gd}{A data frame containing a column with SUBIDs and a column (MAINDOWN) containing the corresponding downstream SUBID, e.g. an imported 'GeoData.txt' file.}

\item{bd}{A data frame with bifurcation connections, e.g. an imported 'BranchData.txt' file. Optional argument.}

\item{progbar}{Logical, display a progress bar while calculating SUBID sorting.}
}
\value{
\code{SortGeoData} returns a GeoData dataframe.
}
\description{
Function to sort an imported GeoData.txt file in downstream order, so that all upstream sub-basins are listed in rows above downstream sub-basins.
}
\details{
GeoData.txt files need to be sorted in downstream order for HYPE to run without errors. \code{SortGeoData} considers bifurcation connections, but not
irrigation or groundwater flow links.
}
\examples{
te <- ReadGeoData(filename = system.file("demo_model", "GeoData.txt", package = "HYPEtools"))
SortGeoData(gd = te)

}
\seealso{
\code{\link{AllUpstreamSubids}}
\code{\link{OutletSubids}}
}
