% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GofMixtureCop.R
\name{GofMixtureCop}
\alias{GofMixtureCop}
\title{Goodness-of-fit of mixture bivariate copula model}
\usage{
GofMixtureCop(R, reg, family, max_iter, eps, n_sample, n_cores)
}
\arguments{
\item{R}{(nx2) data matrix (observations or residuals) that will be transformed to pseudo-observations}

\item{reg}{number of regimes}

\item{family}{'gaussian' , 't' , 'clayton' , 'frank' , 'gumbel'}

\item{max_iter}{maxmimum number of iterations of the EM algorithm}

\item{eps}{precision (stopping criteria); suggestion 0.0001}

\item{n_sample}{number of bootstrap; suggestion 1000}

\item{n_cores}{number of cores to use in the parallel computing}
}
\value{
\item{pvalue}{pvalue (significant when the result is greater than 5)}

\item{theta}{(1 x reg) estimated parameter of the copula according to CRAN copula package (except for Frank copula, where theta = log(theta_R_Package)) for each component (except for degrees of freedom)}

\item{dof}{estimated degree of freedom, only for the Student copula}

\item{Q}{(1 x reg) estimated weights vector}

\item{eta}{(n x reg) conditional probabilities of being in regime k at time t given observations up to time t}

\item{tau}{estimated Kendall tau for each regime}

\item{U}{(n x 2) matrix of Rosenblatt transforms}

\item{cvm}{Cramer-von-Mises statistic for goodness-of-fit}
}
\description{
Goodness-of-fit test of a mixture bivariate copula model
}
\references{
<doi::10.1002/cjs.11534>
}
\author{
By Bruno Remillard, Nov 28, 2010
}
