% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CopulaFamiliesCDF.R
\name{CopulaFamiliesCDF}
\alias{CopulaFamiliesCDF}
\title{CopulaFamiliesCDF}
\usage{
CopulaFamiliesCDF(family, u, ...)
}
\arguments{
\item{family}{copula familly= "gaussian" , "t" , "clayton" , "frank" , "gumbel"}

\item{u}{is an N-by-P matrix of values in [0,1], representing N points in the P-dimensional unit hypercube}

\item{...}{additionnal parameter like RHO  a P-by-P correlation matrix.}
}
\value{
Y = COPULACDF('Gaussian',U,RHO) returns the cumulative probability of the
  Gaussian copula with linear correlation parameters RHO, evaluated at the
  points in U. U is an N-by-P matrix of values in [0,1], representing N
  points in the P-dimensional unit hypercube.  RHO is a P-by-P correlation
  matrix.  If U is an N-by-2 matrix, RHO may also be a scalar correlation
  coefficient.

  Y = COPULACDF('t',U,RHO,NU) returns the cumulative probability of the t
  copula with linear correlation parameters RHO and degrees of freedom
  parameter NU, evaluated at the points in U.  U is an N-by-P matrix of
  values in [0,1]. RHO is a P-by-P correlation matrix.  If U is an N-by-2
  matrix, RHO may also be a scalar correlation coefficient.

  Y = COPULACDF(FAMILY,U,ALPHA) returns the cumulative probability of the
  bivariate Archimedean copula determined by FAMILY, with scalar parameter
  ALPHA, evaluated at the points in U.  FAMILY is 'Clayton', 'Frank', ort
  'Gumbel'.  U is an N-by-2 matrix of values in [0,1].
}
\description{
COPULACDF Cumulative probability function for a copula with linear correlation parameters RHO
}
\examples{
 u = seq(0,1,0.1);
    U1=matrix(rep(u,length(u)),nrow=length(u),byrow = TRUE); U2=t(U1)
   F = CopulaFamiliesCDF('clayton',cbind(c(U1), c(U2)),1)

}
